/*

Macro_Scripts File
Purposes:  
    
	define UI actions for the xView feature introduced in 3ds max 2010

Revision History
	July 2008: Pierre-Felix Breton
	created for 3ds MAX 2010
	July 2008: Michael Zyracki
	finished it

IDs for checkers.
Isolated Vertex 	1
Overlapping Faces 	2
Multiple Edges		3
Open Edges		4
Face Orientation	5
Missing UV Coordinates	6
Overlapping Vertices	7
T-Verts			8
Flipped UVW Faces	9
Overlapped UVW Faces	10

*/

--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--***********************************************************************************************


--***********************************************************************************************
-- Macros to enable each checker, to be hooked in the CUi system
--***********************************************************************************************

MacroScript xView_Isolated_Vertex_Checker
            ButtonText:~XVIEW_ISOLATED_VERTEX_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_ISOLATED_VERTEX_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 1 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 1 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 1
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Overlapping_Faces_Checker
            ButtonText:~XVIEW_OVERLAPPING_FACES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OVERLAPPING_FACES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 2 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 2 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 2
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Multiple_Edges_Checker
            ButtonText:~XVIEW_MULTIPLE_EDGES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_MULTIPLE_EDGES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 3 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 3 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 3
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Open_Edges_Checker
            ButtonText:~XVIEW_OPEN_EDGES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OPEN_EDGES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 4 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 4 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 4
					xViewChecker.On = True
				)
			)	
		Catch()	
	
)--end MacroScript

MacroScript xView_Face_Orientation_Checker
            ButtonText:~XVIEW_FACE_ORIENTATION_CHECKER_BUTTONTEXT~
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_FACE_ORIENTATION_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 5 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 5 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 5
					xViewChecker.On = True
				)
			)	
		Catch()	
	
)--end MacroScript

MacroScript xView_Missing_UV_Coordinates_Checker
            ButtonText:~XVIEW_MISSING_UV_COORDINATES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_MISSING_UV_COORDINATES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 6 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 6 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 6
					xViewChecker.On = True
				)
			)	
		Catch()	
	
)--end MacroScript



MacroScript xView_Overlapping_Vertices_Checker
            ButtonText:~XVIEW_OVERLAPPING_VERTICES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OVERLAPPING_VERTICES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 7 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 7 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 7
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_TVerts_Checker
            ButtonText:~XVIEW_TVERTS_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_TVERTS_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 8 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 8 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 8
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Flipped_UVW_Faces_Checker
            ButtonText:~XVIEW_FLIPPED_UVW_FACES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_FLIPPED_UVW_FACES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 9 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 9 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 9
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Overlapped_UVW_Faces_Checker
            ButtonText:~XVIEW_OVERLAPPED_UVW_FACES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OVERLAPPED_UVW_FACES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 10 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 10 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 10
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

--***********************************************************************************************
-- Macros to cycle through the list of checkers, useful when assigned to a hotkey
--***********************************************************************************************


MacroScript xView_Cycle_Forward
            ButtonText:~XVIEW_CYCLE_FORWARD_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_CYCLE_FORWARD_TOOLTIP~ 
(
	
	On Execute Do 
		Try (
				if (xViewChecker.ActiveIndex < xViewChecker.getNumCheckers()) 
				then xViewChecker.ActiveIndex = xViewChecker.ActiveIndex + 1
				else xViewChecker.ActiveIndex = 1
				xViewChecker.On = true
			)	
		Catch()	
	
)--end MacroScript



MacroScript xView_Cycle_Backward
            ButtonText:~XVIEW_CYCLE_BACKWARD_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_CYCLE_BACKWARD_TOOLTIP~ 
(
	
	On Execute Do 
		Try (
				if (xViewChecker.ActiveIndex > 1) 
				then xViewChecker.ActiveIndex = xViewChecker.ActiveIndex - 1
				else xViewChecker.ActiveIndex = xViewChecker.getNumCheckers()
				xViewChecker.On = true
			)	
		Catch()	
	
)--end MacroScript

--***********************************************************************************************
-- Misc Macros to perform different checker functions
--***********************************************************************************************

MacroScript xView_Select_Results
            ButtonText:~XVIEW_SELECT_RESULTS_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_SELECT_RESULTS_TOOLTIP~ 
(
	
	On Execute Do 
		Try (
				xViewChecker.selectResults sliderTime
			)	
		Catch()	
	 
)--end MacroScript


MacroScript xView_See_Through
            ButtonText:~XVIEW_SEE_THROUGH_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_SEE_THROUGH_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.seeThrough) Catch()
	On Execute Do 
		Try (
			if (xViewChecker.seeThrough==true) 
				then xViewChecker.seeThrough = false
				else xViewChecker.seeThrough = true
			)	
		Catch()	
	 
)--end MacroScript


MacroScript xView_Auto_Update
            ButtonText:~XVIEW_AUTO_UPDATE_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_AUTO_UPDATE_TOOLTIP~ 
(
	on ischecked Return Try(xViewChecker.autoUpdate) Catch()
	On Execute Do 
		Try (
			if (xViewChecker.autoUpdate==true) 
				then xViewChecker.autoupdate = false
				else xViewChecker.autoupdate = true
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Display_On_Top
            ButtonText:~XVIEW_DISPLAY_ON_TOP_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_DISPLAY_ON_TOP_TOOLTIP~ 
(
	on ischecked  Return Try(xViewChecker.displayTextUpTop) Catch()
	On Execute Do 
		Try (

			if (xViewChecker.displayTextUpTop==true) 
				then xViewChecker.displayTextUpTop = false
				else xViewChecker.displayTextUpTop= true
			
			)	
		Catch()	
	 
)--end MacroScript


MacroScript xView_Configure
            ButtonText:~XVIEW_CONFIGURE_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_CONFIGURE_TOOLTIP~ 
(
	on isenabled Return Try(xViewChecker.doesCheckerHavePropDlg xViewChecker.activeIndex == True) Catch()

	On Execute Do 
		Try (
				xViewChecker.showCheckerPropDlg xViewChecker.activeIndex
			)	
		Catch()	
	 
)--end MacroScript



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA9pbbW7Zg3yrsmFvXw7czSBh43Debkm1Dd
-- k82sQKM5+M3NKnC2aXk0E3vyD8nNOW82DIgGyOzkg+91sbNnf6J671E+2Ku7Nki9
-- Vn/wdVrXTybWWVohFlcIl4poNjmN69a9GWpvyRef2oK5lHvZjBJjJRGmHKH8OIl2
-- 9sUZh2p5Af6H9j6M2x9UKDH+ayEua+l/vR3kpBgBpo5lXXbelTtRy0IIRnhVq5PN
-- 2SJjINIU9hH8iYToicwFmQKDK8RerEDQbY/EXw6gMuIUeitYJniy+hF6QoLZCWdI
-- Rl/Ujbh3GoIfrGGMXJht3yrDFpEPNtdQS805fNQzr/uFOKBAatAy
-- -----END-SIGNATURE-----